<?php
// Telegram Bot Webhook для управления фразой
// Токен бота
define('BOT_TOKEN', '8334087038:AAFcSpQMrUXoTENT260A8f3uDPpKfMhgLHA');
define('GROUP_ID', '-1003863534861');
define('PHRASE_FILE', __DIR__ . '/phrase.txt');
define('STATE_FILE', __DIR__ . '/user_state.json'); // Файл для хранения состояний пользователей

// Получаем обновления от Telegram
$content = file_get_contents("php://input");
$update = json_decode($content, true);

// Логирование для отладки
file_put_contents(__DIR__ . '/bot_log.txt', date('Y-m-d H:i:s') . " - " . $content . "\n", FILE_APPEND);

if (!$update) {
    exit;
}

// Обработка callback queries (нажатия на кнопки)
if (isset($update['callback_query'])) {
    $callback = $update['callback_query'];
    $chat_id = $callback['message']['chat']['id'];
    $callback_data = $callback['data'];
    $message_id = $callback['message']['message_id'];
    
    // Ответ на callback (убирает "часики" на кнопке)
    answerCallback($callback['id']);
    
    if ($callback_data === 'set_phrase') {
        // Устанавливаем состояние пользователя "ожидание фразы"
        setUserState($chat_id, 'waiting_phrase');
        
        $keyboard = [[['text' => '🔙 Отмена', 'callback_data' => 'menu']]];
        editMessage($chat_id, $message_id, "✏️ Отправь мне новую фразу для копирования в буфер обмена.\n\nПросто напиши её следующим сообщением.", 'HTML', $keyboard);
    } elseif ($callback_data === 'get_phrase') {
        if (file_exists(PHRASE_FILE)) {
            $current_phrase = file_get_contents(PHRASE_FILE);
            $keyboard = [[['text' => '🔙 Назад в меню', 'callback_data' => 'menu']]];
            editMessage($chat_id, $message_id, "📝 Текущая фраза:\n\n<code>" . htmlspecialchars($current_phrase) . "</code>", 'HTML', $keyboard);
        } else {
            $keyboard = [[['text' => '🔙 Назад в меню', 'callback_data' => 'menu']]];
            editMessage($chat_id, $message_id, "⚠️ Фраза ещё не установлена.", null, $keyboard);
        }
    } elseif ($callback_data === 'menu') {
        // Сбрасываем состояние, если нажали "Отмена" или "Меню"
        clearUserState($chat_id);
        showMenu($chat_id, $message_id, true);
    }
    
    exit;
}

// Обработка обычных сообщений
if (isset($update['message'])) {
    $message = $update['message'];
    $chat_id = $message['chat']['id'];
    $text = $message['text'] ?? '';
    
    // Проверяем состояние пользователя
    $user_state = getUserState($chat_id);
    
    // Если пользователь в состоянии "ожидание фразы"
    if ($user_state === 'waiting_phrase' && $text !== '/start' && $text !== '/menu') {
        // Сохраняем фразу
        file_put_contents(PHRASE_FILE, $text);
        
        // Сбрасываем состояние
        clearUserState($chat_id);
        
        // Отправляем подтверждение с кнопкой возврата в меню
        $keyboard = [[['text' => '🔙 В главное меню', 'callback_data' => 'menu']]];
        sendMessage($chat_id, "✅ Фраза успешно сохранена!\n\n📝 Новая фраза:\n<code>" . htmlspecialchars($text) . "</code>", 'HTML', $keyboard);
        
        // Уведомление в группу
        if ($chat_id != GROUP_ID) {
            sendMessage(GROUP_ID, "🔔 Фраза обновлена пользователем " . ($message['from']['username'] ?? $message['from']['first_name']) . "\n\n📝 Новая фраза:\n<code>" . htmlspecialchars($text) . "</code>", 'HTML');
        }
        
        exit;
    }
    
    // Команда /start или /menu
    if ($text === '/start' || $text === '/menu') {
        clearUserState($chat_id);
        showMenu($chat_id);
        exit;
    }
}

// Функция отображения меню
function showMenu($chat_id, $message_id = null, $edit = false) {
    $keyboard = [
        [
            ['text' => '✏️ Изменить фразу', 'callback_data' => 'set_phrase'],
            ['text' => '📝 Посмотреть фразу', 'callback_data' => 'get_phrase']
        ]
    ];
    
    $menu_text = "🤖 <b>Управление фразой для копирования</b>\n\nВыбери действие:";
    
    if ($edit) {
        editMessage($chat_id, $message_id, $menu_text, 'HTML', $keyboard);
    } else {
        sendMessage($chat_id, $menu_text, 'HTML', $keyboard);
    }
}

// Функция отправки сообщений
function sendMessage($chat_id, $text, $parse_mode = null, $keyboard = null) {
    $url = "https://api.telegram.org/bot" . BOT_TOKEN . "/sendMessage";
    
    $data = [
        'chat_id' => $chat_id,
        'text' => $text
    ];
    
    if ($parse_mode) {
        $data['parse_mode'] = $parse_mode;
    }
    
    if ($keyboard) {
        $data['reply_markup'] = json_encode(['inline_keyboard' => $keyboard]);
    }
    
    $options = [
        'http' => [
            'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
            'method'  => 'POST',
            'content' => http_build_query($data)
        ]
    ];
    
    $context  = stream_context_create($options);
    return file_get_contents($url, false, $context);
}

// Функция редактирования сообщений
function editMessage($chat_id, $message_id, $text, $parse_mode = null, $keyboard = null) {
    $url = "https://api.telegram.org/bot" . BOT_TOKEN . "/editMessageText";
    
    $data = [
        'chat_id' => $chat_id,
        'message_id' => $message_id,
        'text' => $text
    ];
    
    if ($parse_mode) {
        $data['parse_mode'] = $parse_mode;
    }
    
    if ($keyboard) {
        $data['reply_markup'] = json_encode(['inline_keyboard' => $keyboard]);
    }
    
    $options = [
        'http' => [
            'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
            'method'  => 'POST',
            'content' => http_build_query($data)
        ]
    ];
    
    $context  = stream_context_create($options);
    return file_get_contents($url, false, $context);
}

// Функция ответа на callback
function answerCallback($callback_id, $text = null) {
    $url = "https://api.telegram.org/bot" . BOT_TOKEN . "/answerCallbackQuery";
    
    $data = ['callback_query_id' => $callback_id];
    if ($text) {
        $data['text'] = $text;
    }
    
    $options = [
        'http' => [
            'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
            'method'  => 'POST',
            'content' => http_build_query($data)
        ]
    ];
    
    $context  = stream_context_create($options);
    return file_get_contents($url, false, $context);
}

// Функции для работы с состояниями пользователей
function getUserState($chat_id) {
    if (!file_exists(STATE_FILE)) {
        return null;
    }
    
    $states = json_decode(file_get_contents(STATE_FILE), true);
    return $states[$chat_id] ?? null;
}

function setUserState($chat_id, $state) {
    $states = [];
    if (file_exists(STATE_FILE)) {
        $states = json_decode(file_get_contents(STATE_FILE), true);
    }
    
    $states[$chat_id] = $state;
    file_put_contents(STATE_FILE, json_encode($states));
}

function clearUserState($chat_id) {
    if (!file_exists(STATE_FILE)) {
        return;
    }
    
    $states = json_decode(file_get_contents(STATE_FILE), true);
    unset($states[$chat_id]);
    file_put_contents(STATE_FILE, json_encode($states));
}
